/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.model;

import CH.ifa.draw.util.StorableInput;
import CH.ifa.draw.util.StorableOutput;
import DE.siemens.ad.logo.model.AnalogBlockConnector;
import DE.siemens.ad.logo.model.AnalogOutBlockConnector;
import DE.siemens.ad.logo.model.Block;
import DE.siemens.ad.logo.model.InBlockConnector;
import DE.siemens.ad.logo.model.WiringDiagram;
import java.io.IOException;

public class AnalogInBlockConnector
extends InBlockConnector
implements AnalogBlockConnector {
    static final long serialVersionUID = 6071519477492410696L;
    private int serializedDataVersion = 1;

    public AnalogInBlockConnector() {
    }

    public AnalogInBlockConnector(Block aggregat, double defaultValue) {
        this(aggregat, defaultValue, "");
    }

    public AnalogInBlockConnector(Block aggregat, double defaultValue, String name) {
        this.fOwner = aggregat;
        this.fDefaultAnalogValue = defaultValue;
        this.fConnectorName = name;
    }

    public void read(StorableInput dr) throws IOException {
        super.read(dr);
        this.fDefaultAnalogValue = dr.readDouble();
    }

    public void setDefaultValue(double value) {
        this.fDefaultAnalogValue = value;
    }

    public void write(StorableOutput dw) {
        super.write(dw);
        dw.writeDouble(this.fDefaultAnalogValue);
    }

    public int getSignalType() {
        return 1;
    }

    public void setNegated(boolean negate) {
        throw new UnsupportedOperationException(this.getClass().getName() + " supports no negativing");
    }

    public double getAnalogValue() {
        AnalogOutBlockConnector prevConnector = (AnalogOutBlockConnector)this.getLinkedConnector();
        return prevConnector == null ? 0.0 : prevConnector.getAnalogValue();
    }

    public boolean isConnectable() {
        if (!super.isConnectable()) {
            return false;
        }
        WiringDiagram wiringDiagram = this.getOwner().getWiringDiagram();
        if (wiringDiagram != null && wiringDiagram.getProgrammingLanguage().isAnalogInConnectorMultiConnectable()) {
            return true;
        }
        return this.fPreviousConnector == null;
    }
}

